//
// mergepitsnap.C
//
// Version 2001/3/20 Jun Makino
// Created ---
// Merge a nemo atos file into multiple PIT format files
// so that they can read-in in parallel from MP-PIT
//
// Limitation ... does not check consistency for varying N
//

#define MAXINFILES 99
#include "pit_system.h"
#include  <fstream.h>

void print_usage_and_exit()
{
    cerr <<
	 "usage: mergepitsnap -o # -n #"
	 << "    for i (base file name for input),\n"
	 << "        n (number of files),\n"
	 << "        p (output is PIT file),\n"
	 << "        s (output is nemo atos file),\n";
    exit(1);
}

main(int argc, char **argv)
{
    particle_system s;			// input system
    particle_system ssub;  	        // devided system;
    int np = 1;
    int ndigits = 16;
    char ifname[255];
    char ifname_real[255];
    ifstream fsnapin[MAXINFILES];
    extern char *poptarg;
    int pgetopt(int, char **, char *), c;
    bool i_flag = false;
    bool n_flag = false;
    bool p_flag = false;
    bool s_flag = false;
    bool outfile_is_nemo = true;
    
    while ((c = pgetopt(argc, argv, "d:i:n:ps")) != -1) {
	switch (c) {
	    case 'd':
		ndigits = atoi(poptarg);
		break;
	    case 'n':
		n_flag = true;
		np = atoi(poptarg);
		break;
            case 'i': strcpy(ifname,poptarg);
		      i_flag = true;
		      break;
            case 'p': 
		      p_flag = true;
		      break;
            case 's': 
		      s_flag = true;
		      break;
	    case '?':
		print_usage_and_exit();
	}
    }
    if (!i_flag){
	print_usage_and_exit();
    }	
    if (p_flag){
	if (s_flag){
	    cerr << "Both -p and -s given...\n";
	    print_usage_and_exit();
	}
	outfile_is_nemo = false;
    }	
    cerr << "NP = " << np <<endl;
    if (np > MAXINFILES){
	cerr << "NP = " << np << " Too large, exiting..." <<endl;
	exit(1);
    }
    cerr << "Input file name base = " << ifname <<endl;
    cerr.precision(ndigits);
    cout.precision(ndigits);
    for(int iframe=0;;iframe++){
	for (int ip = 0; ip<np; ip++){
	    if(iframe == 0){
		if (np > 1){
		    sprintf(ifname_real,"%sMP%d-%d",ifname,np,ip);
		}else{
		    sprintf(ifname_real,"%s",ifname);
		}
		cerr << " ip = " << ip<< " ifname=" <<ifname_real <<endl;
		fsnapin[ip].open(ifname_real,ios::in);
	    }
	    //	    if (iframe>0){
	    //		cerr << "before reading subframe " << ip <<endl; 
	    //		s.get_pb()->write(cerr);
	    //	    }
	    if(ssub.read(fsnapin[ip])){
		cerr << "End of file for " << ip << endl;
		exit(-1);
	    }
	    //	    if (iframe > 0){
	    //		cerr << "after reading subframe " << ip <<endl; 
	    //		s.get_pb()->write(cerr);
	    //	    }
	    cerr << "Processing frame " << iframe  <<"  proc id " <<ip <<endl;
	    //	    ssub.get_pb()->write(cerr);
	    int ntotal, nlocal;
	    if (ip == 0){
		nlocal = ssub.get_n();
		ntotal = nlocal*np;
		particle * pb_bak = s.get_pb();
		s = ssub;
		if (iframe == 0) {
		    s.set_pb(new particle[ntotal+100]);
		}else{
		    s.set_pb(pb_bak);
		}
		s.set_n(ntotal);
		s.set_nsize(ntotal+100);
	    }else{
		if (ssub.get_n() != nlocal){
		    cerr << "Inconsistent dataset, n = " <<  ssub.get_n()
			 << " != " <<nlocal <<endl;
		    exit(-1);
		}
	    }
	    particle* dest = s.get_pb();
	    particle* source = ssub.get_pb();
	    for(int i=0;i<nlocal;i++){
		dest[source->get_index()] = *source;
		source ++;
	    }
	    //	    cerr << "After assigning subframe " << ip <<endl; 
	    //	    s.get_pb()->write(cerr);
	}
	if (outfile_is_nemo){
	    s.stoa(cout);
	}else{
	    s.write(cout);
	}
    }
}
