#ifndef PIT_SYSTEM_H
#  define PIT_SYSTEM_H
//
//pit_system.h
// generated by generate_class.awk
//
#  define real double
#  define local static
#  define MAX_INPUT_LINE_LENGTH 1024
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <iostream>
using namespace std;
#include "vector.h"
#include "pit_particle.h"
#include "pit_schedule.h"
class particle_system
    {
    private:
        int nsize;
        int n;
        int nbh;
        real time;
        real t_end;
        real eta;
        real eps2;
        vector pos;
        vector vel;
        real mass;
        real max_timestep;
        real t_snap_next;
        real dt_snap_next;
        real t_log_next;
        real dt_log_next;
        particle* pb;
        node_time* nt;
        int ntsize;
        int nprev;
        int nupdated;
        real step_count;
        real MP_step_count;
        int blockstep_count;
        int grape_steps;
        int snapflag;
        int dumpflag;
        int nprocessors;
        int myprocid;
        int grape_nclusters;
        int grape_firstcluster;
        particle* bhp;
        int* bhlocs;
public:
        particle_system(){
            nsize=0 ;
            n=0 ;
            nbh=0 ;
            time=0.0 ;
            t_end=0.0 ;
            eta=0.0 ;
            eps2=0.0 ;
            pos=0.0 ;
            vel=0.0 ;
            mass=0.0 ;
            max_timestep=0.0625e0 ;
            t_snap_next=0.0 ;
            dt_snap_next=0.0 ;
            t_log_next=0.0 ;
            dt_log_next=0.0 ;
            pb=NULL ;
            nt=NULL ;
            ntsize=-1 ;
            nprev=-1 ;
            nupdated=0 ;
            step_count=0.0 ;
            MP_step_count=0.0 ;
            blockstep_count=0 ;
            grape_steps=0 ;
            snapflag=0 ;
            dumpflag=0 ;
            nprocessors=1 ;
            myprocid=0 ;
            grape_nclusters=1 ;
            grape_firstcluster=0 ;
            bhp=NULL ;
            bhlocs=NULL ;
        }
        void set_nsize(int newval){nsize=newval;}
        int get_nsize(){return nsize;}
        int* pget_nsize(){return &nsize;}
        void set_n(int newval){n=newval;}
        int get_n(){return n;}
        int* pget_n(){return &n;}
        void set_nbh(int newval){nbh=newval;}
        int get_nbh(){return nbh;}
        int* pget_nbh(){return &nbh;}
        void set_time(real newval){time=newval;}
        real get_time(){return time;}
        real* pget_time(){return &time;}
        void set_t_end(real newval){t_end=newval;}
        real get_t_end(){return t_end;}
        real* pget_t_end(){return &t_end;}
        void set_eta(real newval){eta=newval;}
        real get_eta(){return eta;}
        real* pget_eta(){return &eta;}
        void set_eps2(real newval){eps2=newval;}
        real get_eps2(){return eps2;}
        real* pget_eps2(){return &eps2;}
        void set_pos(vector newval){pos=newval;}
        vector get_pos(){return pos;}
        vector* pget_pos(){return &pos;}
        void set_vel(vector newval){vel=newval;}
        vector get_vel(){return vel;}
        vector* pget_vel(){return &vel;}
        void set_mass(real newval){mass=newval;}
        real get_mass(){return mass;}
        real* pget_mass(){return &mass;}
        void set_max_timestep(real newval){max_timestep=newval;}
        real get_max_timestep(){return max_timestep;}
        real* pget_max_timestep(){return &max_timestep;}
        void set_t_snap_next(real newval){t_snap_next=newval;}
        real get_t_snap_next(){return t_snap_next;}
        real* pget_t_snap_next(){return &t_snap_next;}
        void set_dt_snap_next(real newval){dt_snap_next=newval;}
        real get_dt_snap_next(){return dt_snap_next;}
        real* pget_dt_snap_next(){return &dt_snap_next;}
        void set_t_log_next(real newval){t_log_next=newval;}
        real get_t_log_next(){return t_log_next;}
        real* pget_t_log_next(){return &t_log_next;}
        void set_dt_log_next(real newval){dt_log_next=newval;}
        real get_dt_log_next(){return dt_log_next;}
        real* pget_dt_log_next(){return &dt_log_next;}
        void set_pb(particle* newval){pb=newval;}
        particle* get_pb(){return pb;}
        particle** pget_pb(){return &pb;}
        void set_nt(node_time* newval){nt=newval;}
        node_time* get_nt(){return nt;}
        node_time** pget_nt(){return &nt;}
        void set_ntsize(int newval){ntsize=newval;}
        int get_ntsize(){return ntsize;}
        int* pget_ntsize(){return &ntsize;}
        void set_nprev(int newval){nprev=newval;}
        int get_nprev(){return nprev;}
        int* pget_nprev(){return &nprev;}
        void set_nupdated(int newval){nupdated=newval;}
        int get_nupdated(){return nupdated;}
        int* pget_nupdated(){return &nupdated;}
        void set_step_count(real newval){step_count=newval;}
        real get_step_count(){return step_count;}
        real* pget_step_count(){return &step_count;}
        void set_MP_step_count(real newval){MP_step_count=newval;}
        real get_MP_step_count(){return MP_step_count;}
        real* pget_MP_step_count(){return &MP_step_count;}
        void set_blockstep_count(int newval){blockstep_count=newval;}
        int get_blockstep_count(){return blockstep_count;}
        int* pget_blockstep_count(){return &blockstep_count;}
        void set_grape_steps(int newval){grape_steps=newval;}
        int get_grape_steps(){return grape_steps;}
        int* pget_grape_steps(){return &grape_steps;}
        void set_snapflag(int newval){snapflag=newval;}
        int get_snapflag(){return snapflag;}
        int* pget_snapflag(){return &snapflag;}
        void set_dumpflag(int newval){dumpflag=newval;}
        int get_dumpflag(){return dumpflag;}
        int* pget_dumpflag(){return &dumpflag;}
        void set_nprocessors(int newval){nprocessors=newval;}
        int get_nprocessors(){return nprocessors;}
        int* pget_nprocessors(){return &nprocessors;}
        void set_myprocid(int newval){myprocid=newval;}
        int get_myprocid(){return myprocid;}
        int* pget_myprocid(){return &myprocid;}
        void set_grape_nclusters(int newval){grape_nclusters=newval;}
        int get_grape_nclusters(){return grape_nclusters;}
        int* pget_grape_nclusters(){return &grape_nclusters;}
        void set_grape_firstcluster(int newval){grape_firstcluster=newval;}
        int get_grape_firstcluster(){return grape_firstcluster;}
        int* pget_grape_firstcluster(){return &grape_firstcluster;}
        void set_bhp(particle* newval){bhp=newval;}
        particle* get_bhp(){return bhp;}
        particle** pget_bhp(){return &bhp;}
        void set_bhlocs(int* newval){bhlocs=newval;}
        int* get_bhlocs(){return bhlocs;}
        int** pget_bhlocs(){return &bhlocs;}
	int read(istream & );
	void write(ostream & s, int olevel=0 );
#include "pit_system_local_members.h"
};
#include "pit_system_additions.h"
#endif //PIT_SYSTEM_H
