/*
 * LOW_ACC_POWER_TEST.C
 *
 * test vector generator for low_acc_power
 *
 * Copyright Jun Makino 1997
 *
 * Version 1.0 Dec 29 1997
 *
 * OUTPUT FORMAT: HEX format
 * in  out
 * hex format for in and out : packed (in the order of exponent, sign, zero and mantissa)
 *
 */
#include "grape6sim.h"
void print_low_acc_power_test(ULONG exp1,
		    ULONG sign1,
		    ULONG zero1,
		    ULONG mantissa1);
void print_low_acc_power_test(ULONG exp1,
		    ULONG sign1,
		    ULONG zero1,
		    ULONG mantissa1)
{
  ULONG in1, ir, nbits, nbits_low;
  LONG acc_old;
  double r2, r;
  nbits = INTERACTION_F_LEN;
  nbits_low = CUTOFF_MANTISSA_LEN;
  in1 = compose_float(nbits, exp1, sign1,  zero1,  mantissa1);
  ir = grape_low_acc_distance(in1);
  r2 = convert_grape_float_to_double(in1, nbits);
  r = convert_grape_float_to_double(ir, nbits_low);
  printf("%lx %lx %le %le %le\n", in1, ir, r2, r, (r*r-r2));
}


main()
{
  ULONG   inb1;
  ULONG exp1, sign1, zero1, mantissa1;
  int i, k;
  for(k = 0; k<2;k++){
    for(i= k; i < (1 <<(CUTOFF_MANTISSA_LEN-1)); i+=3){
      mantissa1 = ((ULONG_ONE)<<(INTERACTION_F_LEN-1))
	| ((ULONG) i )<<(INTERACTION_F_LEN - CUTOFF_MANTISSA_LEN);
      exp1 = INTERACTION_POSITION_EXP_OFFSET+k;
      sign1 = zero1 = 0;
      print_low_acc_power_test(exp1, sign1, zero1, mantissa1);
    }
  }
  for(i= 0; i < 1024; i++){
    mantissa1 = ((ULONG_ONE)<<(INTERACTION_F_LEN-1));
    
    exp1 = i;
    sign1 = zero1 = 0;
    print_low_acc_power_test(exp1, sign1, zero1, mantissa1);
  }
}

