/*
  GRAPE6UTIL.H : header file for G6 utility libraries
  */

/* USEFUL DEFINITIONS */

#ifndef GRAPE6UTIL_H

#define GRAPE6UTIL_H
#include <math.h>

int linkopen(int boardid);
void linkclose(int boardid);
int linkwritef(int boardid,int adrbase,int size, unsigned int *buf);
int linkwrite(int boardid,int link,int size, unsigned int *buf);
int linkread_with_offset(int boardid,
			 int offset,
			 int size,
			 unsigned int *buf);
int linkread(int id,int size,unsigned int *buf);
int linkread8(int id,int size,unsigned int *buf);
int counterclear(int id);
int varcheckw(int boardid,int link,int size);
int varcheckr(int boardid,int size);
int idcheck(int boardid,int errcode);
int linkcheck(int link,int errcode);
int sizecheck(int size,int errcode);
int countercheck(int boardid,int errcode);
int setbaseadr(int link);
void dpramdump(int boardid,int size);
void linkwrite_oneword(int boardid,int link,unsigned int data);

int send_fpga_data(int board,
		   int link,
		   int address,
		   int nconfigbits,
		   char * file_name);
void g6reset(unsigned int boardid);
void g6setledmode(unsigned int boardid,
		  unsigned int mode);
int g6open(int configid);
int g6_send_testpattern(int board,
			char * file_name);

typedef struct grape6_errorcounters{
    int jpperr_count;
    int ipperr_count;
    int memecc_count;
    int memuncorrect_count;
    int cmerror_count;
}GRAPE6_ERRORCOUNTERS;

typedef struct grape6_cluster{
    unsigned long dma_offset;
    int open_state; /* 0: released, 1: acquired */ 
    int fofpga_state; /* 0: not set 1: set */ 
    int ipboardid;
    int foboardid;
    int singleinterface;
    int maxchips;
    int nj;
    int ni;
    int nchips;
    int nchipsperboard;
    int mccount;
    int jp_buffered_mode;
    unsigned int * jp_buffer_p;
    int jp_buffer_size;
    int jp_buffer_current;
    int fofferror_check_mode;
    int fofferror_location;
    int realchips[MAXCHIPSPERCLUSTER];
    int ndefects;
    int defects[MAXCHIPSPERCLUSTER];
    int fscale[MAXPIPELINESPERCHIP];
    int jscale[MAXPIPELINESPERCHIP];
    int phiscale[MAXPIPELINESPERCHIP];
    int system_version;
    int mbuftype;
    char foconf[MAXLINEFORCONFIG];
    char foconfsub[NFOCHIPSONPB][MAXLINEFORCONFIG];
    char folinkconf[MAXLINEFORCONFIG];
    char modfoconf[MAXLINEFORCONFIG];
    char cbfoconfa[MAXLINEFORCONFIG];
    char cbfoconfb[MAXLINEFORCONFIG];
    char cbfoconfc[MAXLINEFORCONFIG];
    char mbufname[MAXLINEFORCONFIG];
    struct grape6_errorcounters errorcounters;
#ifdef SIMULATOR
    int use_simulator;
    SIMGRAPE6_CLUSTER_PTR simg6p;
#endif
}GRAPE6_CLUSTER,* GRAPE6_CLUSTER_PTR;


#define CERRFLAGMASK 	    0xF0000000
#define JPERRFLAGMASK 	    0x80000000
#define ECCCORRFLAGMASK     0x40000000
#define ECCERRFLAGMASK 	    0x20000000
#define IPERRFLAGMASK 	    0x10000000

#endif
    
