#ifndef DEBUG
#define DEBUG (1)
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/mman.h>
/*#include <pcimem.h>*/
#include "memmap.h"

/* local var(s) */

static char *devname[] =
{
    "/dev/"DEVNAME"0",
    "/dev/"DEVNAME"1",
    "/dev/"DEVNAME"2",
    "/dev/"DEVNAME"3",
    "/dev/"DEVNAME"4",
    "/dev/"DEVNAME"5",
    "/dev/"DEVNAME"6",
    "/dev/"DEVNAME"7",
};

static int mapped[][2] =
{
    {0, 0},
    {0, 0},
    {0, 0},
    {0, 0},
    {0, 0},
    {0, 0},
    {0, 0},
    {0, 0},
};

static int fd[] =
{
    -1, -1, -1, -1, -1, -1, -1, -1,
};

static unsigned int * rptr[NPCIMEM];
static unsigned int * mptr[NPCIMEM];

/* local func(s) */
static void TBmemMap(int devid);

#ifdef __linux__
void
TBgetDmaInfo(int devid, unsigned long *pa, unsigned int **va)
     /*
      * pa: physical addr of DMA buf alloced in the kernel space
      * va: virtual addr (in the user process context) pa is mapped to
      */
{

}

unsigned int touch_page_dummy = 1;
void
touch_page(unsigned int *ptr, int size)
{
    int i;
    *ptr = touch_page_dummy;

    for (i = 0; i < size; i++)
    {
	ptr[i] = i;
    }
}


unsigned long
TBdmaMapLoad(int devid, unsigned int *buf, int size)
{
    return 0;
}

#elif defined(__DECC)
#if NODMA
unsigned long
TBdmaMapLoad(int devid, unsigned int * buf, int size)
{
    fprintf(stderr, "TBdmaMapLoad() not implemented yet.\n");
}

#else /* do DMA */


unsigned long
TBdmaMapLoad(int devid, unsigned int *buf, int size)
{
    return 0;
}
#endif /* NODMA */

#else
#error "unsupported environment"
#endif

unsigned int
TBconfigRead(int devid, unsigned int addr)
{
    return 0;
}

void
TBconfigWrite(int devid, unsigned long addr, unsigned int value)
{

}

void
TBregWrite(int devid, unsigned long addr, unsigned int value)
{
}

unsigned int
TBregRead(int devid, unsigned long addr)
{
    return 0;
}

void
TBmemWrite(int devid, unsigned long addr, unsigned int value)
{
    return 0;
}

unsigned int
TBmemRead(int devid, unsigned long addr)
{
    return 0;
}


#if defined(__linux__)

static void
TBmemMap(int devid)
{
}

#elif defined (__DECC)

void
TBmemMap(int devid)
{

}

#else
#error "unsupported environment"
#endif

/*
  TBopen(int devid)

  return values
  non 0: mapped address
  0: failure
  */
caddr_t
TBopen(int devid)
{
    return (caddr_t) 0;
}

void
TBterm(int devid)
{

}
