/*
  G6UTIL.H : header file for G6 utility libraries
  */

/* USEFUL DEFINITIONS */

#ifndef G6UTIL_H

#define G6UTIL_H

#define IPLINK 1
#define JPLINK 2

#define PBLEDMODEADR 0x424
#define PBLED_PROGRAM_MODE 1
#define PBLED_SPEEDOMETER_MODE 0

#define PBLEDDATAADR 0x423

int linkopen(int boardid);
void linkclose(int boardid);
int linkwritef(int boardid,int adrbase,int size, unsigned int *buf);
int linkwrite(int boardid,int link,int size, unsigned int *buf);
int linkread_with_offset(int boardid,
			 int offset,
			 int size,
			 unsigned int *buf);
int linkread(int id,int size,unsigned int *buf);
int linkread8(int id,int size,unsigned int *buf);
int counterclear(int id);
int varcheckw(int boardid,int link,int size);
int varcheckr(int boardid,int size);
int idcheck(int boardid,int errcode);
int linkcheck(int link,int errcode);
int sizecheck(int size,int errcode);
int countercheck(int boardid,int errcode);
int setbaseadr(int link);
void dpramdump(int boardid,int size);
void linkwrite_oneword(int boardid,int link,unsigned int data);

int send_fpga_data(int board,
		   int link,
		   int address,
		   int nconfigbits,
		   char * file_name);
void g6reset(unsigned int boardid);
void g6setledmode(unsigned int boardid,
		  unsigned int mode);
int g6open(unsigned int boardid);
int g6_send_testpattern(int board,
			char * file_name);



#endif
    
