/* created from pcimem.h.template by npcime.csh. do not edit. */

#ifndef PCIMEM_H
#define PCIMEM_H

#define DEVNAME "pcimem"
#define NPCIMEM (4) /* max # of pcimem device */

#if defined(__alpha__)
#define PHIBRAMSIZE (8192)
#elif defined(__i386)
#define PHIBRAMSIZE (4096)
#else
#error "driver is not supported for this environment"
#endif

#define PHIBRAMWORDS (PHIBRAMSIZE>>2) /* word */

/* structure for read/write ioctl */

#include <linux/ioctl.h>

struct long_access
{
	unsigned int addr;
	unsigned int data;
};
enum {MAP_PHIBREG = 0, MAP_DMABUF};

#define PCIMEM_MAGIC (5)
#define WRITE_CFG            _IOW(PCIMEM_MAGIC, 5, struct long_access)
#define READ_CFG             _IOWR(PCIMEM_MAGIC, 4, struct long_access)
#define MAP_BAR2_DENSE_ADDR  _IO(PCIMEM_MAGIC, 11)
#define DMA_MAP_LOAD         _IOWR(PCIMEM_MAGIC, 17, unsigned long)
#define GET_DMA_INFO         _IOWR(PCIMEM_MAGIC, 18, unsigned long)
#define SET_MAP_MODE         _IOW(PCIMEM_MAGIC, 19, unsigned int)

#endif /* PCIMEM_H */
