//
// splitpitsnap.C
//
// Version 2001/3/20 Jun Makino
// Created ---
// Split a nemo atos file into multiple PIT format files
// so that they can read-in in parallel from MP-PIT
//
// 


#include "pit_system.h"
#include  <fstream.h>

void print_usage_and_exit()
{
    cerr <<
	 "usage: splitpitsnap -o # -n #"
	 << "    for o (base file name for output),\n"
	 << "        n (number of files),\n"
	 << "        p (input is PIT file),\n"
	 << "        s (input is nemo atos file),\n"
	 << "        c (consective numbering in each file)\n";
    exit(1);
}

main(int argc, char **argv)
{
    particle_system s;			// input system
    particle_system ssub;  	        // devided system;
    int np = 1;
    char ofname[255];
    char ofname_real[255];
    ofstream fsnapout;
    extern char *poptarg;
    int pgetopt(int, char **, char *), c;
    bool o_flag = false;
    bool n_flag = false;
    bool p_flag = false;
    bool s_flag = false;
    bool infile_is_nemo = true;
    bool consective = false;
    
    while ((c = pgetopt(argc, argv, "cn:o:ps")) != -1) {
	switch (c) {
	    case 'c':
		consective = true;
		break;
	    case 'n':
		n_flag = true;
		np = atoi(poptarg);
		break;
            case 'o': strcpy(ofname,poptarg);
		      o_flag = true;
		      break;
            case 'p': 
		      p_flag = true;
		      break;
            case 's': 
		      s_flag = true;
		      break;
	    case '?':
		print_usage_and_exit();
	}
    }
    if (!o_flag){
	print_usage_and_exit();
    }	
    if (p_flag){
	if (s_flag){
	    cerr << "Both -p and -s given...\n";
	    print_usage_and_exit();
	}
	infile_is_nemo = false;
    }	
		    
    cerr << "NP = " << np <<endl; 
    cerr << "Output file name base = " << ofname <<endl;
    if (infile_is_nemo){
	s.atos(cin);
    }else{
	s.read(cin);
    }	
    cerr.precision(HIGH_PRECISION);
    cout.precision(HIGH_PRECISION);
    int ntotal = s.get_n();
    cerr << "Total number of particles = " << ntotal <<endl;
    if (ntotal % np){
	cerr << "Total number of particles must be multiple of np\n"
	     << ntotal << " " <<np <<endl;
    }
    int nlocal = ntotal/np;
    ssub = s;
    ssub.set_pb(new particle[nlocal+100]);
    ssub.set_n(nlocal);
    ssub.set_nsize(nlocal+100);
    int start_offset = 1;
    int infile_offset = np;
    if (consective){
	start_offset = nlocal;
	infile_offset = 1;
    }
    for (int ip = 0; ip<np; ip++){
	particle* source = s.get_pb() + ip*start_offset;
	particle* dest = ssub.get_pb();
	for(int i=0;i<nlocal;i++){
	    *dest = *source;
	    dest ++; source += infile_offset;
	}
	if (np > 1){
	    sprintf(ofname_real,"%sMP%d-%d",ofname,np,ip);
	}else{
	    sprintf(ofname_real,"%s",ofname);
	}
	cerr << " ip = " << ip<< " ofname=" <<ofname_real <<endl;
	fsnapout.open(ofname_real,ios::out);
	fsnapout.precision(HIGH_PRECISION);
	ssub.write(fsnapout);
	fsnapout.close();
    }
}
