/*
 * PADD.C
 *
 * block float adder for predictor pipeline
 *
 * function padd
 *
 * Copyright Jun Makino 1997
 *
 * Version 1.0 Nov 5 1997
 * Version 1.1 March 1 1998
 * BIG changes:
 * 1998/3/1: padd now masks higher bits for both input and output 
 *
 */
#include "grape6sim.h"
ULONG padd_with_sign(ULONG * result, /* result sigm+mag */
	    ULONG in1, /*   arg 1 */
	    ULONG inb1, /* bit length of arg 1 mag */
	    ULONG in2, /* arg  2*/
	    ULONG inb2, /* bit length of arg 2*/
	    ULONG outb /* bit length of result*/)
{
    ULONG err,s1, s2, m1, m2, sr, mr;
    s1 = (in1>>inb1) & 1;
    m1 = (in1 & ((1<<inb1)-1));
    s2 = (in2>>inb2) & 1;
    m2 = (in2 & ((1<<inb2)-1));
    err = padd(&mr, &sr, m1, s1, inb1, m2, s2, inb2, outb);
    *result = (sr << outb) | mr;
    return err;
}

ULONG padd(ULONG * magnitude, /* result magnitude unsigned integer */
	    ULONG * sign, /* result sign unsigned integer (0:positive) */
	    ULONG in1, /* mag of  arg 1 */
	    ULONG sign1, /* sign of arg  1*/
	    ULONG inb1, /* bit length of arg 1*/
	    ULONG in2, /* mag of  arg  2*/
	    ULONG sign2, /* sign of  arg 2*/
	    ULONG inb2, /* bit length of arg 2*/
	    ULONG outb /* bit length of result*/)
{
    ULONG err = 0;
    /* test if inputs are within range */
    if ((in1 >= (1 <<inb1)) ||(in2 >= (1<<inb2))){
	fprintf(stderr,"padd: in1 or in2 too large, %lx %ld %lx %ld\n",
		in1, inb1, in2, inb2);
	in1 &= (ULONG_ONE <<inb1)-1;
	in2 &= (ULONG_ONE <<inb2)-1;
	err =  1;
    }
    
    if (in1 > in2){
	*sign = sign1;
	if(sign1 != sign2){
	    *magnitude = in1 - in2;
	}else{
	    *magnitude = in1 + in2;
	}
    }else{
	*sign = sign2;
	if(sign1 != sign2){
	    *magnitude = in2 - in1;
	}else{
	    *magnitude = in2 + in1;
	}
    }
    
    /* test if output is within range */
    if ( *magnitude >= (1 <<outb)){
	fprintf(stderr,"padd: output too large %lx %ld %lx %lx",
		*magnitude, outb, in1, in2);
	*magnitude &= (ULONG_ONE <<outb)-1;
	fprintf(stderr," truncated to %lx\n", *magnitude);
	return 1;
    }
    return 0;
}
    
#ifdef TEST
main()
{
  double fmod();
  long si1, si2, d;
  ULONG i1, i2, s1, s2, l1, l2, so, mo, lo, err;
  printf("enter in1, in2, l1, l2, lo: ");
  scanf("%ld%ld%ld%ld%ld",&si1, &si2, &l1, &l2, &lo);
  s1 = s2 = 0;
  if(si1 < 0)s1 = 1;
  if(si2 < 0)s2 = 1;
  i1 = labs(si1);
  i2 = labs(si2);
  d = si1 + si2;
#ifdef TEST_NONSIGNED  
  err = padd(&mo, &so, i1,s1,l1, i2, s2, l2, lo);
  if (so) {
      d +=mo;
  }else{
      d -= mo;
  }
  printf("input 1 = %ld %ld %ld %ld\n", i1, s1, l1, si1);
  printf("input 2 = %ld %ld %ld %ld\n", i2, s2, l2, si2);
  printf("output  = %ld %ld %ld %ld\n", mo, so, si1+si2, d);
#else
  i1 |= s1 <<l1;
  i2 |= s2 <<l2;
  err = padd_with_sign(&mo, i1,l1, i2, l2, lo);
  if (((mo>>lo) & 1) == 0) {
      d -=mo;
  }else{
      d += (mo & ((1<<lo)-1));
  }
  printf("input 1 = "); print_in_binary(i1, l1+1);
  printf("\ninput 2 = "); print_in_binary(i2, l2+1);
  printf("\noutput  = "); print_in_binary(mo, lo+1);
  printf("\noutput  = 0x%lx  %ld error  = %lx\n", mo,  si1+si2, d);
#endif  
}
#endif

