/*
 * POWER_FUNCTIONS_TEST.C
 *
 * test vector generator for power_functions
 *
 * Copyright Jun Makino 1997
 *
 * Version 1.0 Dec 29 1997
 *
 * OUTPUT FORMAT: HEX format
 * in  out
 * hex format for in and out : packed (in the order of exponent, sign, zero and mantissa)
 *
 */
#include "grape6sim.h"
void print_power_functions_test(ULONG exp1,
		    ULONG sign1,
		    ULONG zero1,
		    ULONG mantissa1);
void print_power_functions_test(ULONG exp1,
		    ULONG sign1,
		    ULONG zero1,
		    ULONG mantissa1)
{
  ULONG in1, ir5inv, nbits;
  double r2, r5inv;
  nbits = INTERACTION_F_LEN;
  in1 = compose_float(nbits, exp1, sign1,  zero1,  mantissa1);
  ir5inv = power_function(in1, (ULONG)5, nbits,nbits);
  r2 = convert_grape_float_to_double(in1, nbits);
  r5inv = convert_grape_float_to_double(ir5inv, nbits);
  printf("%lx %lx # %le %le %le\n", in1, ir5inv, r2, r5inv, (r5inv - pow(r2, -2.5)));
}


main()
{
  ULONG   inb1;
  ULONG exp1, sign1, zero1, mantissa1;
  int i, k, j;
  prepare_table( (ULONG) 5, POWER_TABLE_ADDRESS , INTERACTION_F_LEN_U );
  srandom(12345);
  for(k = 0; k<2;k++){
    for(i= k; i < (1 << 8); i+=1){
      j = 0;
      mantissa1 = ((ULONG_ONE)<<(INTERACTION_F_LEN-1))
	| ((ULONG) i )<<(INTERACTION_F_LEN - 9) | j;
      exp1 = INTERACTION_POSITION_EXP_OFFSET+k;
      sign1 = zero1 = 0;
      print_power_functions_test(exp1, sign1, zero1, mantissa1);
      j = random() & 0x7fff;
      mantissa1 = ((ULONG_ONE)<<(INTERACTION_F_LEN-1))
	| ((ULONG) i )<<(INTERACTION_F_LEN - 9) | j;
      print_power_functions_test(exp1, sign1, zero1, mantissa1);
    }
  }
  for(k = 0; k<512; k+= 1){
    
    mantissa1 = ((ULONG_ONE)<<(INTERACTION_F_LEN-1))
      | ((ULONG_ONE)<<(k % INTERACTION_F_LEN));
    exp1 = k+256;
    sign1 = zero1 = 0;
    print_power_functions_test(exp1, sign1, zero1, mantissa1);
  }
}

