#define RETURN_CPU
/*
 * SECOND.c  : returns the CPU time
 *
 * Jun Makino 89/09/20 Ver. 1.00 (created)
 *            89/10/02 Ver. 1.01 debugged on UNIX system.
 *            00/09/21 Ver. 2.00 cleanup of old MS-C stuff
 *
 * functions :
 *             void timer_init() : reset the timer
 *             void second(&double): returns the cpu seconds
 *             void cpumin(&double): returns the cpu minutes
 */
 

#ifdef UNIX	
/*
 *  SECONDS:  returns number of CPU seconds spent so far
 *		This version can be called from fortran routines
 *		in double precision mode
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/times.h>
#include <sys/resource.h>
static double tstart;

#define RETURN_CPU

#ifndef RETURN_CPU
static struct timeval timearg;
static struct timezone zonearg;
#endif

void second_(t)			
double *t;
{
#ifdef RETURN_CPU    
    struct rusage usage;
    if(getrusage(RUSAGE_SELF,&usage)){
	fprintf(stderr,"getrusage failed\n");
    }
    *t =  usage.ru_utime.tv_sec + usage.ru_utime.tv_usec*1e-6;
      
#else
#ifndef xxxx
    if(gettimeofday(&timearg,&zonearg)){
	fprintf(stderr,"Timer failed\n");
    }
    *t =  timearg.tv_sec + timearg.tv_usec*1e-6 - tstart;
#else
    struct tms tbuf;
    int it0;
    it0 = times(&tbuf);
    if(it0 == -1){
	fprintf(stderr,"Time initialization failed\n");
    }
    *t  = it0*0.01 - tstart;
#endif
#endif    
}

void second(t)
double * t;
{
	second_(t);
}
void timer_init()
{
    double ttmp;
    tstart = 0;
    second(&ttmp);
    tstart = ttmp;
}

void tminit_()
{
    timer_init();
}

void xcpumin_(t)
    double*t;
{
    double sec;
    second_(&sec);
    *t=sec/60.0;
}

void cpumin(t)
double * t;
{
	xcpumin_(t);
}

#endif


