/*
 * GRAPH.c  : test program for BIOS/LIO call on PC-9801
 *
 * Jun Makino 89/09/19 coding started
 *
 * This program should be compiled using HUGE model of MS-C
 *
 */
#ifdef J3100
#include "gj3100.c"
#else
#define LINT_ARGS
#include <stdio.h>
#include <memory.h> 
#include <dos.h>
typedef struct  gscr
{
        unsigned char arg1,arg2,arg3,arg4;
}GSCR, *GSCR_PTR;
           end;

typedef struct    gps
{
	short int   arg1,arg2;
        unsigned char  arg3;
}GPS, *GPS_PTR;
unsigned char  buffer[16];
unsigned char   workarea[0x1400];
int  segbase;
int  offset;
GSCR_PTR  screen_arg;
GPS_PTR  pset_arg;

union REGS inregs, outregs;
struct SREGS segs;


void screen(mode,sw,ac,disp)
unsigned int mode, sw, ac, disp;
{
    screen_arg = (GSCR_PTR)(workarea);    
    screen_arg->arg1 = mode;
    screen_arg->arg2 = sw;
    screen_arg->arg3 = ac;
    screen_arg->arg4 = disp;
    inregs.x.bx = offset;
    segs.ds = segbase;
    int86x(0xa1,&inregs, &outregs,&segs);
}

void cls()
{
    segs.ds = segbase;
    int86x(0xa5,&inregs,&outregs,&segs);
}

void pset(x,y, pal)
int x, y;
unsigned char pal;
{
    pset_arg = (GPS_PTR)(workarea);    
    pset_arg->arg1 = x;
    pset_arg->arg2 = y;
    pset_arg->arg3 = pal;
    inregs.x.ax = 0x0100;
    inregs.x.bx = offset;
    segs.ds = segbase;
    int86x(0xa6,&inregs, &outregs,&segs);
}



void  ginit()
{
	unsigned int i, seglio, work;
	unsigned int seg, ofs;
        unsigned int *ptr; 
        seglio = 0xf990;
        ptr = &seglio;
        seg = FP_SEG(ptr);
        ofs = FP_OFF(ptr);
        for (i=0; i<16; i++){
            	movedata(seglio, 6+i*4, 0, (0xa0+i)*4, 2);
            	movedata(seg, ofs, 0, (0xa0+i)*4+2, 2);
        }
  	movedata(seglio, 70, 0, (0xce)*4, 2);
  	movedata(seg, ofs, 0, (0xce)*4+2, 2);
  	ptr = &work;
        seg = FP_SEG(ptr);
        ofs = FP_OFF(ptr);
  	work = 0x8f8; 
  	movedata(seg, ofs, 0, (0xc5)*4, 2);
  	work = 0xfd80; 
  	movedata(seg, ofs, 0, (0xc5)*4+2, 2);
  	ptr = (unsigned int *) workarea;
        segbase = FP_SEG(ptr);
        offset  = FP_OFF(ptr);
        puts("ginit set intr vectors end");
        segs.ds =segbase;
        int86x(0xa0,&inregs, &outregs,&segs);
        screen(3,0,0,1);
        cls();
}
void gquit()
{
}
#endif /* End of 98-specific routines*/
int key_pressed()
{
	inregs.h.ah = 0x06;
	inregs.h.dl = 0xff;
	intdos(&inregs,&outregs);
	return (int) outregs.h.al;
}
int MSDOS_getchar()
{
	inregs.h.ah = 0x01;
	intdos(&inregs,&outregs);
	return (int) outregs.h.al;
}
void clear_text_screen()
{
	putc(0x1b,stderr);
	fputs("[2J",stderr);	
}

#ifdef TEST
main()
{
	int i;
	ginit();
	for(i=0; i<400; i++){
		pset(i,i, (unsigned char) (i % 8));
	}
}
#endif

