#define EPS2BH (1e-7)

inline void particle::accumulate_acc_and_jerk(particle* bj,
				    real eps2)

{
    vector d_pos = bj->pred_pos-pred_pos;
    vector d_vel = bj->pred_vel-pred_vel;

    //	PRC(index); PRL(bj->index);
    //	PRL(bj->pred_pos);PRL(pred_pos);PRL(d_pos);

    real distance_squared = d_pos * d_pos;
    real r2inv = 1.0 / (distance_squared + eps2);
    real a3 = -3.0 * (d_pos * d_vel) * r2inv;
    real mrinv = bj->get_mass() * sqrt(r2inv);
    pot -= mrinv;
    real mr3inv = mrinv * r2inv;
    acc += mr3inv * d_pos;
    jerk += mr3inv * (d_vel + a3 * d_pos);
}


