/*
 * g6chip.h
 */


#ifndef G6CHIP_H

#define G6CHIP_H

typedef union float_and_uint{
    float f;
    unsigned int u;
}FLOAT_AND_UINT;

typedef struct iparticle{
  LONG xi[3];
  ULONG vi[3];
  ULONG eps2;
  ULONG h2;
  ULONG rscale;
  LONG fscale;
  LONG jscale;
  LONG phiscale;
  LONG index;
}IPARTICLE;

typedef struct neighbour_memory{
  ULONG nnb;
  ULONG index[NNBMAX];
  ULONG nbflags[NNBMAX];
  ULONG overflown;
}NEIGHBOUR_MEMORY;

typedef struct pipe_output_register_set{
  LONG  acc[3];
  LONG  jerk[3];
  LONG  phi;
  ULONG rnnb;
  ULONG innb;
  ULONG facc_sum_flag;
  ULONG jacc_sum_flag;
  ULONG pacc_sum_flag;
  ULONG sum_raw_flags[7];
}PIPE_OUTOUT_REGISTER_SET;


typedef struct jparticle{
  ULONG tjlsb;
    ULONG dtjmsb;
    ULONG mass;
    ULONG index;
    ULONG ix[3][5];
}JPARTICLE;

typedef struct predicted_particle{
    ULONG mass;
    ULONG index;
    LONG xj[3];
    ULONG vj[3];
}PREDICTED_PARTICLE;

#define NPIPEPERCHIP 48
#define NPHYSPIPE 6
#define NVIRTUALPIPE 8
#define NNBUNITS 3
typedef struct gchip{
  struct iparticle inreg[NPIPEPERCHIP];
  struct pipe_output_register_set outreg[NPIPEPERCHIP];
  struct neighbour_memory nbmem[NNBUNITS];
}GCHIP;

/*
 *
 * new struct for test vector generation
 *
 */

typedef struct fpipe_input_registor_port{
    ULONG din; /* data port: actually 36 bit width */
    int adri; /* address for force pipeline input registor */
    int adrt; /* address for cutoff table */
    int wei[NPHYSPIPE]; /* WE for physical pipelines */
    int wet; /*table WE */
    int test[15]; /* test bits */
}FPIPE_INPUT_PORT, *FPIPE_INPUT_PORT_PTR;

typedef struct predictor_memory_port{
    struct jparticle jp;
    unsigned int valid_data;
    unsigned int run;
    unsigned int cycle;
}PREDICTOR_MEMORY_PORT, *PREDICTOR_MEMORY_PORT_PTR;

typedef struct predictor_registor_port{
    unsigned int din;
    int wetl;
    int weth;
    int pass[9];
}PREDICTOR_REGISTOR_PORT, *PREDICTOR_REGISTOR_PORT_PTR;

typedef struct fpipe_output_registor_controls{
    int adr; /* address for force pipeline input registor */
}FPIPE_OUTPUT_REGISTOR_CONTROLS, *FPIPE_OUTPUT_REGISTOR_CONTROLS_PTR;

typedef struct fpipe_output_data{
    unsigned int dout[NPHYSPIPE];
    int care_this[NPHYSPIPE]; /* 1: valid data ready */
}FPIPE_OUTPUT_DATA, *FPIPE_OUTPUT_DATA_PTR;


typedef struct nbl_output_registor_controls{
    int adr; /* address for neighbor list data */
}NBL_OUTPUT_REGISTOR_CONTROLS, * NBL_OUTPUT_REGISTOR_CONTROLS_PTR;


typedef struct nbl_output_data{
    unsigned int dout[NNBUNITS];
    int care_this[NNBUNITS]; /* 1: valid data ready */
}NBL_OUTPUT_DATA, *NBL_OUTPUT_DATA_PTR;
    

int getnpipe();

int g6_getnpipe_();

 void set_tunit(int newtunit);
/*      : set the binary point for t*/
 void set_xunit(int newxunit);
/*      : set the binary point for x*/

void  adjust_scaling_parameters(struct iparticle * inreg);

void set_i_particle_xv_on_emulator(int address,
				 double x[3], /* position */
				 double v[3] /* velocity */);

void g6_set_i__xv_(int *address,
				 double x[3], /* position */
				 double v[3] /* velocity */);

void set_i_particle_parms_on_emulator(int address,
				       double eps2,
				       double h2,
				       double rscale,
				       int index);

void set_i_particle_scales_on_emulator(int address,
				       int fscale,
				       int jscale,
				       int phiscale);

void g6_set_i_parms_(int *  address,
				       double * eps2,
				       double * h2,
				       double *rscale,
				       int *index);

void get_i_particle_parms_on_emulator(int address,
				       int * fscale,
				       int * jscale,
				       int * phiscale);

/*  : retrieve scale parameters*/

void set_i_particle_scales_on_emulator_from_real_value(int address,
				       double acc[3],
				       double jerk[3],
				       double phi);
void g6_set_i_scales_from_real_value_(int *address,
				       double acc[3],
				       double jerk[3],
				       double *phi);

int move_i_particles_to_chip(int nparticles,
			     int * index,
			     struct gchip *chip);
int g6_move_i_particles_(int * nparticles,
			     int * index);
/*  : load i-particle data to a chip;*/

ULONG set_j_particle_on_emulator(int address,
				 int index,
				 double tj, /* particle time */
				 double dtj, /* particle time */
				 double mass,
				 double a2by18[3], /* a2dot divided by 18 */
				 double a1by6[3], /* a1dot divided by 6 */
				 double aby2[3], /* a divided by 2 */
				 double v[3], /* velocity */
				 double x[3] /* position */);

/*  : set j-particle on emulator memory*/

void set_ti(double ti);
/*  : set ti*/

void g6_set_ti_(double *ti);
/*  : set ti*/

void run_chip(struct gchip *chip );
     /*  : let a chip to calculate force*/

void g6_run_chip_();
     /*  : let a chip to calculate force*/

void get_force(int pipeid,
	  struct gchip *chip,
	  double acc[3],
	  double jerk[3],
	  double *phi,
	  int *aflag,
	  int *jflag,
	  int *pflag);
void g6_get_force_(int *pipeid,
	  double acc[3],
	  double jerk[3],
	  double *phi,
	  int *aflag,
	  int *jflag,
	  int *pflag);
/*  : retrieve result*/


void read_neighbor_list(struct gchip * chip);

void g6readnbl_(int * ndummy);

int get_neighbor_list(int index,int nblist[]);

int g6getnbl_(int * index, int * nblist);


/* Fortran interface functions */
void g6_set_tunit_(int * newtunit);
void g6_set_njp_(int * n);
void g6_set_xunit_(int * pxunit);
int g6_set_j_particle_(int *address,
				 int *index,
				 double *tj, /* particle time */
				 double *dtj, /* particle time */
				 double *mass,
				 double a2by18[3], /* a2dot divided by 18 */
				 double a1by6[3], /* a1dot divided by 6 */
				 double aby2[3], /* a divided by 2 */
				 double v[3], /* velocity */
				 double x[3] /* position */);

void adjust_i_particle_scales_on_emulator_from_real_value(int address,
				       double acc[3],
				       double jerk[3],
				       double phi);


void put_jparticle(struct jparticle * jp);
void print_jparticle(struct jparticle * jp);

void put_iparticle(struct iparticle * ip,
		   int ivp, /* virtual pipe index */
		   int ipp /* physical pipe index */);
void print_iparticle(struct iparticle * ip);
void put_ti();

void put_fo_controls(FPIPE_OUTPUT_REGISTOR_CONTROLS_PTR focontrols);
void put_fodata(FPIPE_OUTPUT_DATA_PTR fodata);

void put_pipe_result(PIPE_OUTOUT_REGISTER_SET * po,
		   int ivp, /* virtual pipe index */
		   int ipp /* physical pipe index */);
     
void print_pipe_result(PIPE_OUTOUT_REGISTER_SET * po);
void set_run_mode(int mode);
void put_cutoff_tables();
void put_global_rscale();
void print_neighbour_memory(struct gchip *chip );
void put_nb_result(struct neighbour_memory  * pn,
		   int iunit);
void put_nb_controls(NBL_OUTPUT_REGISTOR_CONTROLS_PTR nbcontrols);
void put_nbdata(NBL_OUTPUT_DATA_PTR nbdata);

void print_predicted_particle(struct predicted_particle * pp);
void print_ti();
void print_global_rscale();
void set_output_file(FILE  **fout, char * name);

unsigned int cutoff_data(int addr);

struct chip_control_struct * g6cu_ptr();

struct jparticle * g6jpmem_ptr();
void set_g6chip_nip(int n);

#endif G6CHIP_H
