#ifndef __pciconf_H
#define __pciconf_H
/*
 * Copyright (c) 1996 Picture Elements, Inc.
 *    Stephen Williams
 *
 *    c/o Picture Elements, Inc.
 *    777 Panoramic Way
 *    Berkeley, CA, 94704
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */
#ident "$Id: pciconf.h,v 1.2 1996/10/01 00:47:14 steve Exp $"
/*
 * $Log: pciconf.h,v $
 * Revision 1.2  1996/10/01 00:47:14  steve
 *  Copy notices.
 *
 * Revision 1.1.1.1  1996/09/23 20:20:22  steve
 *  Initial release.
 *
 */

/*
 * The pciconf device driver supports reads and writes to the
 * configuration space of a selected PCI device. One can use lseek to
 * move around within that space.
 */

/*
 * use the PCICONF_SELECT ioctl to tell the pciconf device what device
 * to focus on. From this point, reads and writes will apply to the
 * configuration space of that device.
 *
 * The ioctl takes a pointer to the pciconf_info structure.
 */

struct pciconf_info {
      unsigned short vendor_id;
      unsigned short device_id;
      unsigned short instance;
};

# define PCICONF_SELECT 1

#endif
