/*
 * pcimem.h .... not yet consistent with the template file.
 */

/*
 * memo
 * DECC pre-defined flag: __DECC
 * Linux/Alpha GCC pre-defined flag:  __linux__  __alpha__
 */
#ifndef PCIMEM_H
#define PCIMEM_H

#define DEVNAME "pcimem"
#define NPCIMEM (4) /* max # of pcimem device */ 


#if defined(__linux__)
#define PHIBRAMSIZE (4096)
#elif defined(__DECC)
#define PHIBRAMSIZE (8192)
#else
 driver is not supported for this environment
#endif
#define MAXCLUSTERS (4)

#if defined(__linux__)
#if defined(__alpha__) 
#define LONG_ACCESS_MEMBER_T unsigned long long
#else
#define LONG_ACCESS_MEMBER_T unsigned 
#endif
#elif defined(__DECC)
#define LONG_ACCESS_MEMBER_T unsigned long
#else
 driver is not supported for this environment
#endif

 
#define PHIBRAMWORDS (PHIBRAMSIZE>>2) /* 2k word */

/* structure for read/write ioctl */

#include <linux/ioctl.h>

struct long_access
{
	LONG_ACCESS_MEMBER_T  int addr;
	LONG_ACCESS_MEMBER_T  int data;
};
enum {MAP_PHIBREG = 0, MAP_DMABUF};

#define PCIMEM_MAGIC (5)
#define WRITE_CFG            _IOW(PCIMEM_MAGIC, 5, struct long_access)
#define READ_CFG             _IOWR(PCIMEM_MAGIC, 4, struct long_access)
#define MAP_BAR2_DENSE_ADDR  _IO(PCIMEM_MAGIC, 11)
#define DMA_MAP_LOAD         _IOWR(PCIMEM_MAGIC, 17, unsigned long)
#define GET_DMA_INFO         _IOWR(PCIMEM_MAGIC, 18, unsigned long)
#define SET_MAP_MODE         _IOW(PCIMEM_MAGIC, 19, unsigned int)

#endif /* PCIMEM_H */
