/*
 * TCALC.C
 *
 * function to calculate DT from tnow, tilsb (a) and dtimsbloc (n)
 *
 * Copyright J. Makino 1997
 *
 * Version 1.0 Nov 3, 1997
 *
 */
#include "grape6sim.h"
ULONG tcalc(ULONG * dtout, ULONG tnow, ULONG tilsb, ULONG dtimsbloc)
     /*
       dtout: resulted delta t in DTNBITS bit unsigned integer (lower 24bits)
       tnow : current time in 64 bit unsigned integer
       tilsb : value of lsb(t_i mod delta t_i)
       dtimsbloc: location of 1 for delta t_i (0:LSB, LONGBITS-1:MSB)

       NOTE : range of output is: 0---0x800000, not 0xffffff
       (assuming DTNBITS = 24)
       */
{
  ULONG dt, tmp;
  tmp = 1;
  if ( tilsb & (~ tmp) ){
    fprintf(stderr,"tcalc: tilsb out of range: %lx %lx %lx %lx\n", tilsb,tmp,
	    ~tmp, tilsb & (~ tmp));
    return 1;
  }
  tmp = LONGBITS;
  if (dtimsbloc >= tmp){
    fprintf(stderr,"tcalc: dtimsbloc out of range: %d\n", dtimsbloc);
    return 2;
  }
  dt = (tilsb<< (LONGBITS-1)) ^ (tnow <<(LONGBITS - 1 - dtimsbloc));
  *dtout = dt >> (LONGBITS-DTNBITS);
  return 0;
}
    
#ifdef TEST
main()
{
  double fmod();
  ULONG i, t, a, n, dt, err;
  double realdti,realdt, realt, realti, one;
  one = 1.0;
  printf("size of i = %d\n", sizeof(i));
  printf("enter t, a, n (in hex): ");
  scanf("%lx%lx%lx",&t,&a,&n);
  printf("t,a,n = 0x%x 0x%x 0x%x\n", t, a, n);
  err = tcalc(&dt,t,a,n);
  printf("dt = 0x%x\n", dt);
  realdti = 1.0e0/(1<<n);
  realt = t*realdti;
  realti = fmod(realt,one);
  realdt = realt - realti;
  printf("t,ti, dti, dt = %lf %lf %lf %lf %lf\n",
	 realt, realti, realdti, realdt, (dt*one) /(1<<(DTNBITS-1)));
}
#endif

