/*
 * ADDTEST.C
 *
 * test vector generator for add
 *
 * Copyright Jun Makino 1997
 *
 * Version 1.0 Dec 29 1997
 *
 * OUTPUT FORMAT: HEX format
 * in1 in2 sum
 * hex format: packed (in the order of exponent, sign, zero and mantissa)
 *
 */
#include "grape6sim.h"
void print_add_test(ULONG exp1,
		    ULONG sign1,
		    ULONG zero1,
		    ULONG mantissa1,
		    ULONG exp2,
		    ULONG sign2,
		    ULONG zero2,
		    ULONG mantissa2)
{
  ULONG in1, in2, sum, nbits;
  double f1, f2, fsum;
  nbits = BITS;
  in1 = compose_float(nbits, exp1, sign1,  zero1,  mantissa1);
  in2 = compose_float(nbits, exp2, sign2,  zero2,  mantissa2);
  sum =  add(in1, in2,  nbits, nbits, nbits);

  f1 = convert_grape_float_to_double(in1, nbits);
  f2 = convert_grape_float_to_double(in2, nbits);
  fsum =  convert_grape_float_to_double(sum, nbits);
  printf("%lx %lx %lx # %le %le %le %le\n", in1, in2, sum,
	 f1, f2, fsum, fsum - f1 - f2);
}


main()
{
  ULONG  in1, in2, inb1, inb2, outb, sum ;
  ULONG exp1, sign1, zero1, mantissa1;
  ULONG exp2, sign2, zero2, mantissa2;
  int  i;
  inb1 = inb2 = outb = BITS;

  /* testing policy:
     a) mantissa adder
     * all 0 or all 1
     * shift by shifter
     *
     */

  for(i= -BITS-2;i <= BITS+2; i ++){
    exp1 = INTERACTION_POSITION_EXP_OFFSET;
    exp2 = exp1 + i;
    sign1 = sign2 = 0;
    zero1 = zero2 = 0;
    mantissa1 = mantissa2 = (ULONG_ONE) << (BITS-1);
    print_add_test(exp1, sign1, zero1, mantissa1, exp2, sign2, zero2, mantissa2);
  }
  for(i= -BITS-2;i <= BITS+2; i ++){
    exp1 = INTERACTION_POSITION_EXP_OFFSET;
    exp2 = exp1 + i;
    sign1 = sign2 = 0;
    zero1 = zero2 = 0;
    mantissa1 = mantissa2 = ((ULONG_ONE) << BITS)-1;
    print_add_test(exp1, sign1, zero1, mantissa1, exp2, sign2, zero2, mantissa2);
  }
  for(i= 0;i <10; i ++){
    exp1 = ULONG_ONE <<i;
    exp2 = exp1 + i;
    sign1 = sign2 = 0;
    zero1 = zero2 = 0;
    mantissa1 = mantissa2 = ((ULONG_ONE) << BITS)-1;
    print_add_test(exp1, sign1, zero1, mantissa1, exp2, sign2, zero2, mantissa2);
    sign1 = 1;
    print_add_test(exp1, sign1, zero1, mantissa1, exp2, sign2, zero2, mantissa2);
    zero1 = 1;
    print_add_test(exp1, sign1, zero1, mantissa1, exp2, sign2, zero2, mantissa2);
  }
  srandom(1234567);
  for (i=0; i< 100; i++){
    exp1 = exp2 = random();
    sign1 =random();
    sign2 =random();
    zero1 = zero2 = 0;
    mantissa1 = random();
    mantissa2 = random();
    mantissa1 |= (ULONG_ONE) << (BITS-1);
    mantissa2 |= (ULONG_ONE) << (BITS-1);
    print_add_test(exp1, sign1, zero1, mantissa1, exp2, sign2, zero2, mantissa2);
  }
  for (i=0; i< 100; i++){
    exp1 = 512;
    exp2 = random();
    sign1 =random();
    sign2 =random();
    zero1 = zero2 = 0;
    mantissa1 = random();
    mantissa2 = random();
    mantissa1 |= (ULONG_ONE) << (BITS-1);
    mantissa2 |= (ULONG_ONE) << (BITS-1);
    print_add_test(exp1, sign1, zero1, mantissa1, exp2, sign2, zero2, mantissa2);
  }
}
