/*
 * ecc64.h
 */

void set_parity_matrix(); /* initialize parity generator/checker */

ULONG generate_parity(ULONG data); /* generate full ECC parity data */

int check_and_correct_data(ULONG *data, ULONG *parity);
/* return = 1 : single error corrected
   = 2 : double error uncorrected */
						 
unsigned int  generate_byte_parity(unsigned int  data);
/* byte parity for 32 bit data, returns 4-bit parity */

unsigned int check_byte_parity(unsigned int data, unsigned int parity);
/* check byte parity for 32 bit data */
