/*
 * GRPLOT.c : graphic subroutines for GRAPE driver
 *
 * Jun Makino 89/90/19 Ver. 0.00 (created)
 *            89/10/02 Ver. 0.01
 *                     Modified for UNIX system - NOGRAPHICS flag added
 *            91/07/23 Ver 0.2
 *                     SUNVIEW (NEMO-YAPP) INTERFACE
 *
 * should be used with GRAPH.c
 */

#ifdef BIG
#define NMAX 131072
#else
#define NMAX 32769
#endif
#ifndef NEMOOUT
#include <stdio.h>
#else
#include <stdinc.h>
#ifdef sun4
#include <suntool/sunview.h>
#include <suntool/canvas.h>
extern Pixwin  *yapp_sv_pw;
struct pr_pos pw_vect[NMAX];
#endif
#endif

static float y_scale; 
static int plotsw;
static int reflesh = 0;
static int active_page = 0;
static int screen_mode =3;
static int x1,my_y1,x2,y2;

void get_window_parms(px1,py1,px2,py2,pcmode)
int * px1;
int * py1;
int * px2;
int * py2;
int * pcmode;
{
	*px1 = x1;
	*py1 = my_y1;
	*px2 = x2;
	*py2 = y2;
	*pcmode = screen_mode & 1;
}
void initialize_plot(infile)
FILE * infile;    
{
	float ymax;
	int view_size;
#ifdef NOGRAPHICS
	return;
#else
	fprintf(stderr,"x1,y1,size of viewport, size of window : ");
	fscanf(infile, "%d%d%d%f", &x1,&my_y1,&view_size,&ymax);
	plotsw = (ymax > 0.0);
	x2=x1+view_size;
	y2=my_y1+view_size;
	if(plotsw){
		fprintf(stderr,"Reflesh? (0:no, else:yes) ");
		fscanf(infile, "%d", &reflesh);
		fprintf(stderr,"Color? (0:no, else:yes) ");
		fscanf(infile, "%d", &screen_mode);
		if(screen_mode){
			screen_mode = 3;
		}else{
			screen_mode = 2;
		}
#   ifdef MSC		
		ginit();
		screen(screen_mode,0,0,1);
#   endif		
		y_scale = ymax;
	}
#   ifdef NEMO
	plinit("",(float) x1, (float) x2, (float)my_y1, (float)y2);
#   endif	
#endif
}

void plot_particles_window(n,x,x1,my_y1,x2,y2, y_size)
int n;
float x[][3];
int x1,my_y1,x2,y2;	/* viewport location */
float y_size;
{
#ifndef NOGRAPHICS
	int i,ix, iy;
	int cx, cy;
	int iplot, nplot;
	unsigned char pal;	
	float scale;
	cx = (x1 + x2)/2;
	cy = (my_y1 + y2)/2;
	scale = (y2-my_y1)/y_size;
	for(i=0, iplot = 0; i<n; i++){
/*		printf("(plot) i, x, y, yscale : %d %f %f %f\n",
		       i, x[i][0], x[i][1], y_scale);*/
		ix = cx + x[i][0]*scale;
		iy = cy - x[i][1]*scale;
		pal = (i % 7) + 1;
		if((ix <= x2) && (ix >= x1) && (iy <=y2) &&(iy >= my_y1)){
#   ifdef MSC		    
			pset(ix, iy, pal);
#   endif
#   ifdef NEMO
#      if 0			
			plpoint((double)ix, (double)iy);
#      endif
#      if 1			
			pw_vect[iplot].x = plix((double)ix);
			pw_vect[iplot].y = pliy((double)iy);
			iplot ++;
#      endif			
#   endif			
		}
/*		printf("(plot) x, y, pal : %d %d %d\n", ix, iy, pal);*/
	}
#ifdef NEMO
	plframe2();
	pw_polypoint(yapp_sv_pw, 0, 0, iplot, pw_vect,PIX_SET);
	plflush();
#endif	
#   endif
}

void plot_particles(n,x)
int n;
float x[][3];
{
	int i,ix, iy;
	int disp_page;
#ifndef NOGRAPHICS
	unsigned char pal;
	if (!plotsw) return;
	if(reflesh) {
#   ifdef MSC	    
		cls();
#   endif
#   ifdef NEMO
#if 0		
		plframe();
#endif		
#   endif		
	}
	plot_particles_window(n,x,x1,my_y1,x2,y2,y_scale);
#   ifdef MSC	
	if(reflesh>0) {
		if(active_page){
			if(screen_mode == 3){
				disp_page = 17;
			}else{
				disp_page = 2;
			}
			active_page=0;
		}else{
			disp_page = 1;
			active_page = 1;
		}
		screen(screen_mode,0,active_page, disp_page);
	}
#   endif	
#endif
}

