/*
 *snapout.c : Makino private interface to use NEMO filestruct
 *
 *	13-Nov-1990  V1.0 created		Jun Makino
 *                      (adopted from gtos.c) 
 *      21-Sep-2000  V2.0 cleanup of old non-nemo stuff Jun Makino
 */

/**************** INCLUDE FILES ********************************/ 

#include <stdinc.h>		/* also takes stdio.h */
#include <vectmath.h>
#include <filestruct.h>
#include <snapshot/snapshot.h>
#include <math.h>
#include <ctype.h>

/**************** SOME GLOBAL VARIABLES ************************/

#if !defined(HUGE)
#define HUGE 1e20
#endif
int coordsys = CSCode(Cartesian, NDIM, 2);

stream fortran_outstr;

void convert_fortran_string_to_cstr(fstr,flen,cstr)
    char * fstr;
    int flen;
    char * cstr;
{
    int i;
    strncpy(cstr,fstr,flen);
    for(i=0;i<flen;i++){
	if(*(cstr + i) == ' ') *(cstr + i) = 0;
    }
    *(cstr + flen) = 0;
}
    
int fortran_setnemosnapoutfile_(name,length)
    char * name;
    int length;
{
    char fnamebuf[200];
    convert_fortran_string_to_cstr(name,length,fnamebuf);
    fortran_outstr = stropen(fnamebuf,"w");
    return 0;
}
int nemo_snapout(nbody,time,mass,pos,vel,pot, outstr)
    int nbody;
    real time;
    real mass[];
    real pos[][3];
    real vel[][3];
    real pot[];
    stream  outstr;
{
    int ndim,i, j, k;
    real*  phasep;
    real tdum;
    tdum = time;
    ndim = 3;
    put_set(outstr, SnapShotTag);		/*   start snapshot output  */
    put_set(outstr, ParametersTag);
    put_data(outstr, TimeTag, RealType, &tdum, 0);
    put_data(outstr, NobjTag, IntType, &nbody, 0);
    put_tes(outstr, ParametersTag);
    put_set(outstr, ParticlesTag);		/*   start particle output  */
    put_data(outstr, CoordSystemTag, IntType, &coordsys, 0);
    put_data(outstr, MassTag, RealType, mass, nbody, 0);
    phasep = (real*)malloc(sizeof(real)*nbody*6); 
    if(phasep == NULL){
	fprintf(stderr,"nemo_snapout, not enough memory, exit\n");
	exit(-1);
    }
    for(i=0; i<nbody; i++){
	for(k=0; k<3; k++){
	    *(phasep+i*6+k) = pos[i][k];
	    *(phasep+i*6+k+3) = vel[i][k];
	}
    }
    put_data(outstr, PhaseSpaceTag,
	     RealType,phasep, nbody, 2, NDIM, 0);
    free(phasep);
    if(pot !=NULL)put_data(outstr, PotentialTag, RealType, pot, nbody, 0);
    put_tes(outstr, ParticlesTag);
    put_tes(outstr, SnapShotTag);
    return 0;
}

void fortran_nemosnapout_(nbody,time,mass,pos,vel,pot)
    int *nbody;
    real *time;
    real mass[];
    real pos[][3];
    real vel[][3];
    real pot[];
{
    nemo_snapout(*nbody,*time,mass,pos,vel,pot,fortran_outstr);
}
