/*
 * SUBX.C
 *
 * subtract positions and convert to float
 *
 * function subx
 *
 * Copyright Jun Makino 1997
 *
 * Version 1.0 Nov 10 1997
 *
 */
#include <stdlib.h> 
#include "grape6sim.h"
/* subx : calculate in1-in2
 * result format:
 * matissa 24 bits
 * zero flag 1 bit
 * sign 1 bit
 * exponent 10 bit biased (actually used: 6 bits...)
 */

ULONG position_priority_encoder(ULONG x);
ULONG position_shifter(ULONG data, ULONG control);
ULONG subx(LONG in1,	    LONG in2) ;
LONG convert_position_float_to_long(ULONG );

ULONG position_priority_encoder(ULONG x)
{
    int i;
    for(i=LONGBITS-1; i>=0;i--){
	  dprintf(11,"i, x, mask = %d, %lx, %lx\n", i, x, ((LONG)1)<<i);
	  if (x & (((LONG)1)<<i)){
	    return i;
	}
    }
    return 0;
}
ULONG position_shifter(ULONG data, ULONG control)
{
#define POSITION_SHIFTER_OUTPUT INTERACTION_F_LEN
    ULONG z;
#ifdef X86
    dprintf(3, "position_shifter data, control, nshifts = %Lx %Ld %Ld\n",
	    data, control, LONGBITS - control-1);
#else
    dprintf(3, "position_shifter data, control, nshifts = %lx %ld %ld\n",
	    data, control, LONGBITS - control-1);
#endif
    if ((control < 0 ) || (data == 0)){
      return (ULONG) 0;
    }
    data = data << (LONGBITS - control -1); /* shift data to max position */
#ifdef X86
    dprintf(3, "shifted data1 = %Lx\n", data);
#else
    dprintf(3, "shifted data1 = %lx\n", data);
#endif
    data = force_1_round_and_shift(data, LONGBITS, INTERACTION_F_LEN);
#ifdef X86
    dprintf(3, "shifted data2 = %Lx\n", data);
#else
    dprintf(3, "shifted data2 = %lx\n", data);
#endif
    return data;
}


ULONG subx(LONG in1, /*   arg 1 */
	    LONG in2) /* arg  2*/
{
  LONG dxfixed, dxfixedmag; 
  ULONG  dxsign, dxmantissa, dxzero;
  ULONG dxexp, dx;
  dxfixed = in1 - in2;
#ifdef X86
  dprintf(3, "in1, in2, dx = %Lx %Lx %Lx\n", in1, in2, dxfixed);
#else
  dprintf(3, "in1, in2, dx = %lx %lx %lx\n", in1, in2, dxfixed);
#endif  
  dxzero = 0;
  if (dxfixed == (ULONG) 0){
    dxzero = 1;
  }
#ifndef X86  
  dxfixedmag = labs(dxfixed);
#else
  dxfixedmag = dxfixed; if (dxfixedmag <0) dxfixedmag = - dxfixedmag;
#endif  
  dxsign = ((ULONG) dxfixed) >> (LONGBITS-1);
  dxexp =  position_priority_encoder(dxfixedmag);
  dxmantissa = position_shifter(dxfixedmag, dxexp);
#ifdef X86
  dprintf(3, "exp, sign, mantissa = %Ld %Ld 0x%Lx\n", dxexp, dxsign, dxmantissa);
#else
  dprintf(3, "exp, sign, mantissa = %ld %ld 0x%lx\n", dxexp, dxsign, dxmantissa);
#endif
  dxexp += INTERACTION_POSITION_EXP_OFFSET+1;
  dx =  (dxexp)<<(INTERACTION_F_LEN + 2)
    | (dxsign)<<(INTERACTION_F_LEN + 1)
    | (dxzero)<<(INTERACTION_F_LEN)
    | dxmantissa;
  return dx;

}


LONG convert_position_float_to_long(ULONG indata)
{
  LONG dxfixed;
  ULONG  dxmag, dxsign, dxmantissa, dxzero;
  ULONG dxexp, dx;
  dxexp = indata >>(INTERACTION_F_LEN + 2);
  dxsign = (indata >>(INTERACTION_F_LEN + 1)) & 1;
  dxmag = indata & ((1<<INTERACTION_F_LEN)-1);
  dprintf(3, "exp, sign, mantissa = %ld %ld 0x%lx\n", dxexp, dxsign, dxmag);
  dxmag = dxmag<<((int)(64-INTERACTION_F_LEN));
  dxmag = dxmag >>(64-(dxexp-512));
  dxfixed = dxmag;
  if(dxsign) dxfixed = - dxfixed;
  return dxfixed;
}
#ifdef TEST


LONG long_random(void)
{
  LONG x1, x2, x3;
  x1 = (LONG)random();
  x2 = (LONG)random();
  x3 = (LONG)random();
  return (x1<<34) | (x2<<2) | (x3 &3);
}
#define INTERACTIVE
#ifdef INTERACTIVE
main()
{
  LONG si1, si2;
  ULONG dx;
  set_debug_level(4);
  printf("enter in1, in2: ");
  scanf("%ld%ld",&si1, &si2);
  dx = subx(si1, si2);
  printf("x1, x2, dx = 0x%lx  0x%lx  0x%lx %ld\n", si1, si2, dx, convert_position_float_to_long(dx));
  
}
#endif
#ifdef RANDOM_TEST
main()
{
  LONG si1, si2, realdx, simulateddx;
  ULONG dx;
  int expdx, experr, i, ierr;
  set_debug_level(0);
  srandom(1);
  ierr = 0;
  for (i=0; i<1000000000; i++){
    si1 = long_random();
    
    si2 = long_random();
    dx = subx(si1, si2);
    realdx = si1 - si2;
    simulateddx = convert_position_float_to_long(dx);
    dprintf(3,"x1, x2, dx = 0x%lx  0x%lx  0x%lx 0x%lx 0x%lx\n",
	   si1, si2, dx, realdx, realdx - simulateddx);
    frexp(realdx + 0.0, &expdx);
    frexp(realdx-simulateddx + 0.0, &experr);
    if (realdx == simulateddx) experr = -10000;
    dprintf(3,"exp err = %ld\n", expdx - experr);
    if (expdx - experr < 24) ierr ++;
    if ((i % 100000) == 0){
      printf("i, ierr = %d %d\n", i, ierr);
    }
  }
  
}
#endif
#ifdef EVALUATION
main()
{
  LONG si1, si2, realdx, simulateddx, imax, jshift,nshifts, s1, s2;
  ULONG dx;
  int expdx, experr, dbg_level;
  LONG i, ierr;
  set_debug_level(0);
  srandom(1);
  ierr = 0;
  i = 0;
  printf("enter imax, nsifts, dbg_level: ");
  scanf("%ld %ld %ld",&imax,&nshifts, &dbg_level);
  set_debug_level(dbg_level);
  for(jshift = 0; jshift <nshifts; jshift++){
    for (s1 = -imax; s1<= imax; s1 ++){
      for (s2 = -imax; s2<= imax; s2 ++){
	si1 = s1 << jshift;
	si2 = s2 << jshift;
	i++;
	dx = subx(si1, si2);
	realdx = si1 - si2;
	simulateddx = convert_position_float_to_long(dx);
	dprintf(3,"x1, x2, dx = 0x%lx  0x%lx  0x%lx 0x%lx 0x%lx\n",
		si1, si2, dx, realdx, realdx - simulateddx);
	frexp(realdx + 0.0, &expdx);
	frexp(realdx-simulateddx + 0.0, &experr);
	if (realdx == simulateddx) experr = -10000;
	dprintf(1,"exp err = %ld\n", expdx - experr);
	if ((expdx - experr < 24) && (realdx != 0)) {
	  ierr ++;
	  dprintf(0,"x1, x2, dx = 0x%lx  0x%lx  0x%lx 0x%lx 0x%lx\n",
		  si1, si2, dx, realdx, realdx - simulateddx);
	  dprintf(0,"exp,  err = %ld %ld\n", expdx,  experr);
	}
	if ((i % 100000) == 0){
	  printf("i, ierr = %ld %ld\n", i, ierr);
	  
	}
      }
    }
  }
}
#endif
#endif




