/*
 *  GRIO.c  : I/O routines for GRAPE-1
 *
 *  Jun Makino 89/09/22 Ver. 0.00 (created)
 *             89/09/26 Ver. 0.01
 *                      Does not overwrite existing files
 *             89/10/02 Ver. 0.02
 *                      Modified for UNIX system
 *                      NOGRAPHICS flag for systems with which on-the-fly
 *                      graphics is not available or slow.
 *             90/11/13 Ver. 0.10
 *                      NEMO filestruct output support (-DNEMOOUT)
               00/09/21 Cleanup of very old stuffs...
 *
 *  input file format : atos format (nemo)
 *  output file format : binary raw file (4 byte int, REAL)
 *
 *
 */
#include <stdio.h>
#include <unistd.h>

#define NEMOOUT 1
#ifndef REAL
#define REAL float
#define SHORTREAL
#endif

#ifdef NEMO
#include <stdinc.h>
#include <getparam.h>
static stream out_snap_file = NULL;
static stream in_snap_file = NULL;
#else
#include <stdio.h>
FILE * out_snap_file = NULL;
FILE * in_snap_file  = NULL;
#endif

#   define READBINARY "r"
#   define WRITEBINARY "w"

#include "grape.h"
#ifdef NEMO
int set_input_file()
{
    in_snap_file = stropen(getparam("in"),"r");
    if(in_snap_file == NULL){
	printf("Can't open input snap file %s\n", getparam("in"));
	return 1;
    }
    printf("input snap = %s\n",getparam("in"));
    return 0;
}
#else
int set_input_file()
{
    char infilename[255];
    scanf("%s",infilename);
    in_snap_file = fopen(infilename,"r");
    if(in_snap_file == NULL){
	printf("Can't open input snap file %s\n", infilename);
	return 1;
    }
    printf("input snap = %s\n",infilename);
    return 0;
}
#endif

int file_exist(name)
char name[];
{
	FILE * fptr;
	if((fptr=fopen(name,"r"))!=NULL){
		fclose(fptr);
		return 1;
	}else{
#ifdef MSC
		clearerr(fptr);
#endif
		return 0;
	}
}
void output_file_check_and_exit(name)
char name[];
{
	if(file_exist(name)){
		fprintf(stderr,"output file %s exists\n",name);
		exit(1);
	}
}

#ifdef NEMO
int set_output_snap_file()
{
	int iret;
	if(getparam("out")[0] != '~'){
		out_snap_file = stropen(getparam("out"),"w");
	}else{
		out_snap_file = NULL;
	}
	printf("output snap = %s\n", getparam("out"));
	return 0;
}
#else
int set_output_snap_file()
{
	char outfilename[255];
	scanf("%s",outfilename);
	if(outfilename[0] != '~'){
		out_snap_file = fopen(outfilename,"w");
	}else{
		out_snap_file = NULL;
	}
	printf("output snap = %s\n", outfilename);
	return 0;
}

#endif

int set_input_binary_file(file)
FILE ** file;
{
	char inname[200];
	fprintf(stderr,
	       "Enter in_snap file name (binary) :");
	scanf("%s", inname);
	in_snap_file = fopen(inname, READBINARY);
	if(in_snap_file == NULL){
		printf("Can't open input snap file %s\n", inname);
		return 1;
	}
	*file = in_snap_file;
	printf("input snap = %s\n",inname);
	return 0;
}
	
int read_snap(n,t,m,x,v, nmax)
int * n;	/* output	number of particles */
REAL * t;	/* output	system time */
REAL m[];	/* output	mass data */
REAL x[][3];	/* output	position data */
REAL v[][3];	/* output	velocity data */
int nmax;	/* input	max of particle number */
{
	int ndim, i;
	fscanf(in_snap_file,"%d", n);
	if(*n > nmax){
		printf("particle number %d exceeds max (%d)\n",*n, nmax);
		return 1;
	}
	fscanf(in_snap_file,"%d", &ndim);
	if(ndim != 3){
		printf("dimension number %d not suppoeted (should be %d)\n",
		ndim, 3);
		return 1;
	}
#ifdef SHORTREAL
#define FORM1 "%f"	
#define FORM3 "%f%f%f"
#else
#ifdef sun4
#define FORM1 "%F"	
#define FORM3 "%F%F%F"
#else
#define FORM1 "%lf"	
#define FORM3 "%lf%lf%lf"
#endif	
#endif	
	fscanf(in_snap_file,FORM1, t);
	for(i=0; i<*n; i++){
		fscanf(in_snap_file,FORM1,&m[i]);
	}
	for(i=0; i<*n; i++){
		fscanf(in_snap_file,FORM3,&x[i][0],&x[i][1],&x[i][2]);
	}
	for(i=0; i<*n; i++){
		fscanf(in_snap_file,FORM3,&v[i][0],&v[i][1],&v[i][2]);
	}
	return 0;
}
#ifdef NEMO
int out_snap_binary(n,t,m,x,v,pot,pflag)
int n;		/* input	number of particles */
REAL t;	/* input	system time */
REAL m[];	/* input	mass data */
REAL x[][3];	/* input	position data */
REAL v[][3];	/* input	velocity data */
REAL pot[];	/* input	potential data */
int pflag;	/* input        flag to output potential */
{
    
    long int nl, ndiml;
    int iword;
    REAL tdum;
    int iret;
    if(out_snap_file == NULL){
	return 0;
    }
    if(pflag){
	iret = nemo_snapout(n,t,m,x,v,pot,out_snap_file);
    }else{
	iret = nemo_snapout(n,t,m,x,v,NULL,out_snap_file);
    }
    fflush(out_snap_file);
    return iret;
}
#else
int out_snap_binary(n,t,m,x,v,pot,pflag)
     /* Sorry, this actually uses ASCII STOA format... */
int n;		/* input	number of particles */
REAL t;	/* input	system time */
REAL m[];	/* input	mass data */
REAL x[][3];	/* input	position data */
REAL v[][3];	/* input	velocity data */
REAL pot[];	/* input	potential data */
int pflag;	/* input        flag to output potential */
{
    int i,iret = 0;
    if(out_snap_file == NULL){
	return 0;
    }
    fprintf(out_snap_file, "%d\n%d\n%e\n", n,3,t);
    for(i=0;i<n;i++){
	fprintf(out_snap_file,"%21.14e\n", m[i]);
    }
    for(i=0;i<n;i++){
	fprintf(out_snap_file,"%21.14e %21.14e %21.14e\n", x[i][0],x[i][1],x[i][2]);
    }
    for(i=0;i<n;i++){
	fprintf(out_snap_file,"%21.14e %21.14e %21.14e\n", v[i][0],v[i][1],v[i][2]);
    }
    if(pflag){
	for(i=0;i<n;i++){
	    fprintf(out_snap_file,"%21.14e\n", pot[i]);
	}
    }
    fflush(out_snap_file);
    return iret;
}
#endif



