#ifndef MEMMAP_H
#define MEMMAP_H

#define CFG_SIZE   (0x80)
#define REG_SIZE   (0x00000200)
#define MEM_SIZE   (0x0000f000)
/*
#define REG_SIZE   (0x00000200)
#define MEM_SIZE   (0x0000f000)

#define REG_SIZE   (0x00010000)
#define MEM_SIZE   (0x00010000)
*/
#define DEV_OFFSET (0x00010000)

#ifdef __linux__
#define MB /* do nothing */
#else
#include <c_asm.h>
#define MB asm("mb")
#endif

#define TBmemWriteInt(addr, value){*(((u_int *)mp)+(addr)) = (value);MB;}

unsigned int * TBopen(int devid);
void TBterm(int devid);
unsigned int TBconfigRead(int devid, unsigned int addr);
void TBconfigWrite(int devid, unsigned int addr, unsigned int value);
unsigned int TBmemRead(int devid, unsigned int addr);
void TBmemWrite(int devid, unsigned int addr, unsigned int value);
unsigned int TBregRead(int devid, unsigned int addr);
void TBregWrite(int devid, unsigned int addr, unsigned int value);
unsigned long TBdmaMapLoad(int devid, unsigned int * buf, int size);

#endif /* MEMMAP_H */
