/*
 * FADD.C
 * accumulate force etc with specified bit length and offset
 * function fadd
 * Copyright Jun Makino 1997
 *
 * Version 1.0 Nov 20 1997
 * Version 1.1 Dec 21 1997
 *     -- interpretation of the offset changed
 * Version 1.2 Apr 7 1998
 *     -- calculation of offset now all done in unsigned
 *
 *          
 *
 */
#include "grape6sim.h"
ULONG fadd(ULONG f, /* force etc from a particle */
	   LONG * accumulator, /* ACCUMULATOR*/
	   ULONG inbits, /* input mantissa length */
	   LONG offset, /* base value to add to the exponent before shift */
	   ULONG outbits,/* accumulator bit length */
	   ULONG clear)
     /* return value : error code
	0: okay
	1: force overflow
	2: acc overflow
	4: force underflow
	*/
     
{
  ULONG  exponent, sign, zero, mantissa;
  LONG loc, nshifts, fint;
  ULONG accsign, newsign_inv;
  ULONG err = 0;
  ULONG offset_u;
  ULONG sgnmask = (ULONG_ONE) <<(outbits-1);
  ULONG offmask = (ULONG) 0x3ff;
  dprintf(2,"(fadd) f, a, inbits, offset, outbits, clear = 0x%lx %ld %ld %ld %ld %ld",
	  f, *accumulator, inbits, offset, outbits, clear);
  if (clear) *accumulator = (LONG) 0;
  decompose_float(f, inbits, &exponent, &sign, &zero, &mantissa);
  offset_u = offset;
  offset_u &= offmask;
  
  nshifts = (exponent + offset) & offmask;
  dprintf(2,"(fadd), zero, nshift = %ld %ld\n", zero, nshifts);
  if ((nshifts &   ((ULONG) 0x200)) || (nshifts == LONG_ZERO)){
    err |= (ULONG) 4;
    zero = 1;
  }else if (nshifts >= ((LONG) outbits) ){
    err |= (ULONG) 1;
    zero = 1;
    dprintf(2,"(fadd) err, zero, nshift = %ld %ld\n", zero, nshifts);
  }
  if (nshifts >= ((LONG) outbits - 1) ){
    dprintf(2,"(fadd) almost error 1, zero, nshift = %ld %ld\n", zero, nshifts);
  }
  loc = nshifts & ((ULONG) (outbits - 1));
  dprintf(2,"(fadd) nshifts, loc = %ld %ld\n", nshifts,loc);
  mantissa = force_1_round_and_shift(mantissa, inbits, (ULONG) loc);
  dprintf(2, "(fadd)  mantissa = %ld\n", mantissa);
  fint = mantissa;
  if(sign) fint = -fint;
  dprintf(2, "(fadd)  fint after sign = %ld 0x%lx\n", fint, fint);
  if(zero != ULONG_ZERO) fint = 0;
  dprintf(2, "(fadd) fint after zero = %ld %ld 0x%lx\n", zero, fint, fint);
  accsign = 0;
  if(((ULONG)*accumulator) & sgnmask) accsign = 1;
  *accumulator += fint;
  newsign_inv = 1;
  dprintf(2, "(fadd) sign, accsign, newsign_inv = %ld %ld %ld\n", sign, accsign, newsign_inv);
  
  if(((ULONG)*accumulator) & sgnmask) newsign_inv = 0;
  if((sign == accsign) && (accsign == newsign_inv)){
    err |= (ULONG) 2;
    dprintf(2,"(fadd) err 2, zero, nshift = %ld %ld\n", zero, nshifts);
  }
  dprintf(2,"(fadd) err = %lx\n", err);
  return err;
}
    


#ifdef TEST


LONG long_random(void)
{
  LONG x1, x2, x3;
  x1 = (LONG)random();
  x2 = (LONG)random();
  x3 = (LONG)random();
  return (x1<<34) | (x2<<2) | (x3 &3);
}

main()
{
  double  a, f, sum;
  ULONG  fi;
  LONG ai, offset;
  ULONG  fbits;
  set_debug_level(4);
  printf("enter a, f, offset, fbits: ");
  scanf("%lf%lf%ld%ld",&a, &f, &offset, &fbits);
  sum = a + f;
  printf("a, f, offset, a+f =  %le %le %ld %le\n", a, f, offset, sum);
  ai = ldexp(a, (int) fbits);
  fi = convert_double_to_grape_float(f, fbits );
  fadd(fi, &ai, fbits, offset, (ULONG) 64, (ULONG) 0);
  a = scalb((double)ai, - ((int)fbits));
  printf(" a+f, sum, err  =  %le %le %le\n", a, sum, (a -sum) /(a+sum)*0.5);
}
#endif


