/*
 * grape6util-local.h
 *
 * local definitions & variables
 *
 * Copyright J. Makino
 * Version 0.0 March 6 2000
 */

#ifndef GRAPE6UTIL_LOCAL_H

#define GRAPE6UTIL_LOCAL_H


#define IPLINK 1
#define JPLINK 2

#define G6MAXCLUSTERS 32
#define MAXPIPELINESPERCHIP 48
#define MAXBURST 8192    

#define MAXCHIPSPERCLUSTER 512
#define MAXBOARDSPERCLUSTER 16
#define MAXLINEFORCONFIG 255
#define MAXNJPERCHIP 16384

#define NFOCHIPSONPB 7

#define PBLEDMODEADR 0x424
#define PBLED_PROGRAM_MODE 1
#define PBLED_SPEEDOMETER_MODE 0

#define PBLEDDATAADR 0x423
#define CBJPMODEADR  0x425
#define B0PLLMODEADR  0x426
#define B1PLLMODEADR  0x427
#define JPSPACEADDR   0x428

#if 0
#define NMBUFTYPES 5 
#define FAIRCHILDLCX16374A 0
#define TOSHIBALCX16374A   1
#define TIALVCH16374       2
#define FAIRCHILDLCX16374ANEW  3
#define TEST               4
#endif

#ifndef GRAPE6SIM_H
#ifdef ALPHA
typedef  unsigned long ULONG;
typedef  long LONG;
#endif
#ifdef X86
typedef  unsigned long long ULONG;
typedef  long long LONG;
#endif
#endif
#define CONVERT_DOUBLE_TO_GRAPE_INT_POS(x,unit)  (rint(ldexp((x),(unit))))
#define CONVERT_GRAPE_INT_POS_TO_DOUBLE(x,unit) (ldexp((double)(x),-((int)(unit))))

#define PRED_V_LEN 24
#define PRED_A_LEN 20
#define PRED_A1_LEN 16
#define PRED_A2_LEN 10
#define LONGBITS 64


#define DEFAULT_TUNIT 51
#define DEFAULT_XUNIT 50
#define GRAPE6_CONFIG_FILE "GRAPE6_CONFIG_FILE"

#ifndef DEFINE_IN_GRAPPE6UTIL
#define DEFINE_IN_GRAPPE6UTIL extern
#endif

DEFINE_IN_GRAPPE6UTIL LONG tunit;
DEFINE_IN_GRAPPE6UTIL LONG xunit;
DEFINE_IN_GRAPPE6UTIL double xscale2, xscaleinv, xscale;
DEFINE_IN_GRAPPE6UTIL double dtmin_g6;
DEFINE_IN_GRAPPE6UTIL int dtminexp_g6;

static int mkmintab[5] = {0,1,6,10,16};
static int lentab[5] = {LONGBITS, PRED_V_LEN, PRED_A_LEN,
PRED_A1_LEN, PRED_A2_LEN};
DEFINE_IN_GRAPPE6UTIL unsigned int ni;
DEFINE_IN_GRAPPE6UTIL int global_rscale;

#define JPREG_BASE_ADDRESS 0x800
#define JPREG_MC_ADDRESS 0x812
#define JP_ADLY 1
#define JP_WDLY 1
#define JP_ODLY 2
#define JP_DDLY 1
#define JPREG_VCID_ADDRESS 0x811 

#define IPREG_BASE_ADDRESS 0x400
#define IPREG_ND_ADDRESS 0x410

#define FOREG_BASE_ADDRESS 0x1000
#define FOREG_ND_ADDRESS 0x1013
#define FOREG_INACTIVE_ADDRESS 0x1014

#define CALC_BASE_ADDRESS 0x1400
#define CALC_LRAM 2 /* SSRAM read access latency */
#define CALC_LFORCE 0x30 /*force pipeline latency for sts? */

#define CUTOFF_BASE_ADDRESS 0xc00 
#define CUTOFF_RSCALE_ADDRESS 0xc80 

#define TI_BASE_ADDRESS 0x1800

#define NIP_ADDRESS 0x1012


#define FLAGMASK 	    0x13FF24
#define TESTFLAGMASK 	    (0xF0124924)
	    /* neglect: all underflow  */
	    /* i.e. 1111 0000 0001 0010 0100 1001 0010 0100 = 0xF0124924 */
#define FORCEFLAGMASK 	    (0x000000DB) /* 1101 1011 */
#define JERKFLAGMASK 	    (0x0001B600) /* 0001 1011 0110 */
#define POTFLAGMASK 	    (0x000C0000) /* 1100 */
#define COMMERROR           1
#define FORCESCALINGERROR   2
#define JERKSCALINGERROR    3
#define POTSCALINGERROR     4

#define DMA_MAX_SIZE 0x800

/*
 * definitions taken from g6control.h
 */

/*
 * IPW
 */
#define IPW_MAXMAP 16
#define IPW_MAXREG 13
#define IPW_MAXPACKET 8192

#define IPW_IPW_ADDRESS 1
#define IPW_JPW_ADDRESS 2
#define IPW_CTAB_ADDRESS 3
#define IPW_FO_ADDRESS 4
#define IPW_CALC_ADDRESS 5
#define IPW_TI_ADDRESS 6
#define IPW_ND_ADDRESS 16
#define IPW_TESTMODE_ADDRESS 17

#define IPW_INTERNAL_ADDRESS 0x400
#define IPW_JPW_INTERNAL_ADDRESS 0x800
#define IPW_CUTOFF_INTERNAL_ADDRESS 0xc00
#define IPW_RSCALE_INTERNAL_ADDRESS 0xc80
#define IPW_FO_INTERNAL_ADDRESS 0x1000
#define IPW_CALC_INTERNAL_ADDRESS 0x1400
#define IPW_TI_INTERNAL_ADDRESS 0x1800

#define IPW_LOCAL_ADDRESS_MASK 0x3ff
#define IPW_UNIT_ADDRESS_MASK 0xfc00

/*FO control register address map*/
#define FO_MAP_MAX (0xf)
#define FO_CMD0_ADR (0x10)
#define FO_CMD1_ADR (0x11)
#define FO_NI_ADR (0x12)
#define FO_NW_ADR (0x13)
#define FO_INACTIVE_ADR (0x14)

#define FO_MAX_LATENCY 10
#define FO_PIPE_READ_LATENCY 0
#define FO_NBL_READ_LATENCY 0

#define FO_NDATA_ADDRESS (0x200)

#endif

